/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.link;

import com.zurrtum.create.Create;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.equipment.clipboard.ClipboardCloneable;
import com.zurrtum.create.content.redstone.link.IRedstoneLinkable;
import com.zurrtum.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import java.util.Optional;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;

public class ServerLinkBehaviour
extends BlockEntityBehaviour<SmartBlockEntity>
implements IRedstoneLinkable,
ClipboardCloneable {
    public static final BehaviourType<ServerLinkBehaviour> TYPE = new BehaviourType();
    public RedstoneLinkNetworkHandler.Frequency frequencyFirst = RedstoneLinkNetworkHandler.Frequency.EMPTY;
    public RedstoneLinkNetworkHandler.Frequency frequencyLast = RedstoneLinkNetworkHandler.Frequency.EMPTY;
    class_243 textShift = class_243.field_1353;
    public boolean newPosition = true;
    private Mode mode;
    private IntSupplier transmission;
    private IntConsumer signalCallback;

    protected ServerLinkBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public static ServerLinkBehaviour receiver(SmartBlockEntity be, IntConsumer signalCallback) {
        ServerLinkBehaviour behaviour = new ServerLinkBehaviour(be);
        behaviour.signalCallback = signalCallback;
        behaviour.mode = Mode.RECEIVE;
        return behaviour;
    }

    public static ServerLinkBehaviour transmitter(SmartBlockEntity be, IntSupplier transmission) {
        ServerLinkBehaviour behaviour = new ServerLinkBehaviour(be);
        behaviour.transmission = transmission;
        behaviour.mode = Mode.TRANSMIT;
        return behaviour;
    }

    public ServerLinkBehaviour moveText(class_243 shift) {
        this.textShift = shift;
        return this;
    }

    public void copyItemsFrom(ServerLinkBehaviour behaviour) {
        if (behaviour == null) {
            return;
        }
        this.frequencyFirst = behaviour.frequencyFirst;
        this.frequencyLast = behaviour.frequencyLast;
    }

    @Override
    public boolean isListening() {
        return this.mode == Mode.RECEIVE;
    }

    @Override
    public int getTransmittedStrength() {
        return this.mode == Mode.TRANSMIT ? this.transmission.getAsInt() : 0;
    }

    @Override
    public void setReceivedStrength(int networkPower) {
        if (!this.newPosition) {
            return;
        }
        this.signalCallback.accept(networkPower);
    }

    public void notifySignalChange() {
        Create.REDSTONE_LINK_NETWORK_HANDLER.updateNetworkOf((class_1936)this.getLevel(), this);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.getLevel().method_8608()) {
            return;
        }
        this.getHandler().addToNetwork((class_1936)this.getLevel(), this);
        this.newPosition = true;
    }

    @Override
    public Couple<RedstoneLinkNetworkHandler.Frequency> getNetworkKey() {
        return Couple.create(this.frequencyFirst, this.frequencyLast);
    }

    @Override
    public void unload() {
        super.unload();
        if (this.getLevel().method_8608()) {
            return;
        }
        this.getHandler().removeFromNetwork((class_1936)this.getLevel(), this);
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71468("FrequencyFirst", RedstoneLinkNetworkHandler.Frequency.CODEC, (Object)this.frequencyFirst);
        view.method_71468("FrequencyLast", RedstoneLinkNetworkHandler.Frequency.CODEC, (Object)this.frequencyLast);
        view.method_71468("LastKnownPosition", class_2338.field_25064, (Object)this.blockEntity.method_11016());
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        this.newPosition = view.method_71426("LastKnownPosition", class_2338.field_25064).map(pos -> !this.blockEntity.method_11016().equals(pos)).orElse(true);
        super.read(view, clientPacket);
        this.frequencyFirst = view.method_71426("FrequencyFirst", RedstoneLinkNetworkHandler.Frequency.CODEC).orElse(RedstoneLinkNetworkHandler.Frequency.EMPTY);
        this.frequencyLast = view.method_71426("FrequencyLast", RedstoneLinkNetworkHandler.Frequency.CODEC).orElse(RedstoneLinkNetworkHandler.Frequency.EMPTY);
    }

    public void setFrequency(boolean first, class_1799 stack) {
        boolean changed;
        stack = stack.method_7972();
        stack.method_7939(1);
        class_1799 toCompare = first ? this.frequencyFirst.getStack() : this.frequencyLast.getStack();
        boolean bl = changed = !class_1799.method_31577((class_1799)stack, (class_1799)toCompare);
        if (changed) {
            this.getHandler().removeFromNetwork((class_1936)this.getLevel(), this);
        }
        if (first) {
            this.frequencyFirst = RedstoneLinkNetworkHandler.Frequency.of(stack);
        } else {
            this.frequencyLast = RedstoneLinkNetworkHandler.Frequency.of(stack);
        }
        if (!changed) {
            return;
        }
        this.blockEntity.sendData();
        this.getHandler().addToNetwork((class_1936)this.getLevel(), this);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    private RedstoneLinkNetworkHandler getHandler() {
        return Create.REDSTONE_LINK_NETWORK_HANDLER;
    }

    @Override
    public boolean isAlive() {
        class_1937 level = this.getLevel();
        class_2338 pos = this.getPos();
        if (this.blockEntity.isChunkUnloaded()) {
            return false;
        }
        if (this.blockEntity.method_11015()) {
            return false;
        }
        if (!level.method_8477(pos)) {
            return false;
        }
        return level.method_8321(pos) == this.blockEntity;
    }

    @Override
    public class_2338 getLocation() {
        return this.getPos();
    }

    @Override
    public String getClipboardKey() {
        return "Frequencies";
    }

    @Override
    public boolean writeToClipboard(class_11372 view, class_2350 side) {
        view.method_71468("First", class_1799.field_49266, (Object)this.frequencyFirst.getStack());
        view.method_71468("Last", class_1799.field_49266, (Object)this.frequencyLast.getStack());
        return true;
    }

    @Override
    public boolean readFromClipboard(class_11368 view, class_1657 player, class_2350 side, boolean simulate) {
        Optional first = view.method_71426("First", class_1799.field_49266);
        if (first.isEmpty()) {
            return false;
        }
        Optional last = view.method_71426("Last", class_1799.field_49266);
        if (last.isEmpty()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.setFrequency(true, (class_1799)first.get());
        this.setFrequency(false, (class_1799)last.get());
        return true;
    }

    static enum Mode {
        TRANSMIT,
        RECEIVE;

    }
}

